<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>OHLC Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array( 
        array("x" => 1483209000000, "y" => array( 104.4, 111.89, 99.11, 109.18)),
        array("x" => 1485887400000, "y" => array( 110.58, 120.92, 95.7, 101.48)),
        array("x" => 1488306600000, "y" => array( 103.79, 110, 95.17, 108.93)),
        array("x" => 1490985000000, "y" => array( 104.74, 147, 102.31, 144.35)),
        array("x" => 1493577000000, "y" => array( 144.99, 168.5, 142.11, 144.56)),
        array("x" => 1496255400000, "y" => array( 145.05, 169.93, 138.58, 162.51)),
        array("x" => 1498847400000, "y" => array( 162.13, 174.56, 152.91, 169.44)),
        array("x" => 1501525800000, "y" => array( 169.95, 191.2, 162.71, 178.77)),
        array("x" => 1504204200000, "y" => array( 180.8, 207.89, 177, 206.81)),
        array("x" => 1506796200000, "y" => array( 209.35, 218.67, 191.23, 200.71)),
        array("x" => 1509474600000, "y" => array( 207.2, 218.67, 200.37, 216.14)),
        array("x" => 1512066600000, "y" => array( 199.31, 200.3, 180.58, 193.5))
    )
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            theme: "light2",
            title: {
                text: "NVIDIA Corporation Stock Price - 2017"
            },
            axisX: {
                valueFormatString: "MMM",
                intervalType: "month",
                interval: 1
            },
            axisY: {
                title: "Stock Price (in USD)",
                prefix: "$"
            },
            data: [{
                type: "ohlc",
                xValueType: "dateTime",
                yValueFormatString: "$#,##0.0",
                xValueFormatString: "MMM",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });

        chart.render();
    }
</script>

<?php include '../footer.php'; ?>